------------------------------
-- F-15E ARMT A/G Page -------
------------------------------
dofile(LockOn_Options.script_path.."MFDG/MFDG_definitions.lua")
dofile(LockOn_Options.script_path.."MFDG/ARMT/ARMT_Menu.lua")

local	ARMT_Symbol					= CreateElement "ceSimple"
		ARMT_Symbol.name			= "Multiple_Release_Options"
		ARMT_Symbol.init_pos		= {0, 0, 0}
		ARMT_Symbol.controllers		= {{"armt_AG_MultRel_Options"}}
Add_MFDG_Element(ARMT_Symbol)

-- LABELS
local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "PAGE_FOOTER"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX(0.0), PosY(-0.80), 0}
		ARMT_Text.value				= "OPTIONS"
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_150]
		ARMT_Text.alignment			= "CenterTop"
Add_MFDG_Element(ARMT_Text)

local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "PACS_RDY"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX( 0.65), PosY( -0.77), 0}
		ARMT_Text.value				= "RDY"
		ARMT_Text.controllers		= {{"armt_AG_RDY"}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "CenterTop"
Add_MFDG_Element(ARMT_Text)

local	ARMT_Symbol					= CreateElement "ceSMultiLine"
		ARMT_Symbol.name			= "PACS_RDY_BOX"
		ARMT_Symbol.material		= stroke_material
		ARMT_Symbol.init_pos		= {0, PosY(-0.01), 0}
		ARMT_Symbol.parent_element	= "PACS_RDY"
		ARMT_Symbol.points_set		= {"stroke_symbols_MFDG", "PACS_Mode_Box"}
		ARMT_Symbol.scale			= MFDG_STRK_SCALE
AddMFDGStrokeSymbol(ARMT_Symbol)

-- MASTER MODES
local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "AG_CMBT"
		ARMT_Text.material			= stroke_fontgreen						--Change to green
		ARMT_Text.init_pos			= {PosX(0.68), PosY( 0.57), 0}
		ARMT_Text.formats			= {"A/G %s"}
		ARMT_Text.controllers		= {{"armt_AG_Mode"}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "CenterTop"
Add_MFDG_Element(ARMT_Text)

local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "AA_CMBT"
		ARMT_Text.material			= stroke_fontgreen						--Change to green
		ARMT_Text.init_pos			= {PosX(0.68), PosY( 0.49), 0}
		ARMT_Text.formats			= {"A/A %s"}
		ARMT_Text.controllers		= {{"armt_AA_Mode"}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "CenterTop"
Add_MFDG_Element(ARMT_Text)

-- AAMs
local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "AAM_LOAD"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {0, PosY( 0.0), 0}
		ARMT_Text.formats			= {"%s"}
		ARMT_Text.controllers		= {{"armt_AG_AAM"}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "CenterTop"
Add_MFDG_Element(ARMT_Text)

-- CBU OPTIONS
local sta_col = 0.66

for sta = 16, 20 do

	sta_col = 0.66 - (0.33 * (sta - 16))
	
	local	ARMT_Text					= CreateElement "ceStringSLine"
			ARMT_Text.name				= string.format("CB_Station_%02d", sta)
			ARMT_Text.material			= stroke_font
			ARMT_Text.init_pos			= {PosX(sta_col), PosY(0.72), 0}
			ARMT_Text.formats			= {"%s"}
			ARMT_Text.controllers		= {{"armt_AG_CBU_Option", sta}}
			ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
			ARMT_Text.alignment			= "CenterCenter"
	Add_MFDG_Element(ARMT_Text)

end

-- DELIVERY OPTIONS
local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "LOFT_ANGLE"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX(-0.70), PosY( 0.37), 0}
		ARMT_Text.formats			= {"%s"}
		ARMT_Text.controllers		= {{"armt_AG_DLVRY_PRG", DLVRY_LOFT}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "LeftTop"
Add_MFDG_Element(ARMT_Text)

local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "TIME_ARMT"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX(-0.70), PosY( 0.30), 0}
		ARMT_Text.formats			= {"%s"}
		ARMT_Text.controllers		= {{"armt_AG_DLVRY_PRG", DLVRY_TARM}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "LeftTop"
Add_MFDG_Element(ARMT_Text)

local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "LOFT_ALTITUDE"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX( 0.55), PosY( 0.37), 0}
		ARMT_Text.formats			= {"%s"}
		ARMT_Text.controllers		= {{"armt_AG_DLVRY_PRG", DLVRY_ATBIAS}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "LeftTop"
Add_MFDG_Element(ARMT_Text)

local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "CT_SIDE"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX( 0.55), PosY( 0.30), 0}
		ARMT_Text.formats			= {"%s"}
		ARMT_Text.controllers		= {{"armt_AG_DLVRY_PRG", DLVRY_CT_BIAS}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "LeftTop"
Add_MFDG_Element(ARMT_Text)

-- RELEASE PROGRAMMING
local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "REL_MODE"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX(-0.65), PosY(-0.73), 0}
		ARMT_Text.formats			= {"%s"}
		ARMT_Text.controllers		= {{"armt_AG_DLVRY_PRG", DLVRY_MODE}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "CenterBottom"
Add_MFDG_Element(ARMT_Text)

local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "REL_SEQ"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX(-0.33), PosY(-0.73), 0}
		ARMT_Text.formats			= {"%s"}
		ARMT_Text.controllers		= {{"armt_AG_DLVRY_PRG", DLVRY_SQNCE}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "CenterBottom"
Add_MFDG_Element(ARMT_Text)

local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "REL_FUZING"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX(-0.00), PosY(-0.73), 0}
		ARMT_Text.formats			= {"%s"}
		ARMT_Text.controllers		= {{"armt_AG_DLVRY_PRG", DLVRY_FUZNG}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "CenterBottom"
Add_MFDG_Element(ARMT_Text)


local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "REL_QTY_L"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX(-0.95), PosY( -0.40), 0}
		ARMT_Text.parent_element	= "Multiple_Release_Options"
		ARMT_Text.value				= "QTY"
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "LeftTop"
Add_MFDG_Element(ARMT_Text)

local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "REL_QTY"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX(-0.77), PosY( -0.40), 0}
		ARMT_Text.parent_element	= "Multiple_Release_Options"
		ARMT_Text.formats			= {"%02d"}
		ARMT_Text.controllers		= {{"armt_AG_RelQty", MFDG_STRK_SCALE}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "LeftTop"
Add_MFDG_Element(ARMT_Text)

local	ARMT_Text					= CreateElement "ceStringSLine"
		ARMT_Text.name				= "REL_INT"
		ARMT_Text.material			= stroke_font
		ARMT_Text.init_pos			= {PosX(0.81), PosY( -0.40), 0}
		ARMT_Text.parent_element	= "Multiple_Release_Options"
		ARMT_Text.formats			= {"INTVL %03d"}
		ARMT_Text.controllers		= {{"armt_AG_RelInt"}}
		ARMT_Text.stringdefs		= stringdefs[STROKE_FNT_DFLT_100]
		ARMT_Text.alignment			= "RightTop"
Add_MFDG_Element(ARMT_Text)

-- SYMBOLS
local	ARMT_Symbol					= CreateElement "ceSMultiLine"
		ARMT_Symbol.name			= "AC_MASTERMODE"
		ARMT_Symbol.material		= stroke_fontgreen					--MASTER MODE BOX TO GREEN
		ARMT_Symbol.init_pos		= {PosX(0.68), PosY( 0.55), 0}
		ARMT_Symbol.controllers		= {{"armt_Current_Mode", MFDG_STRK_SCALE}}
		ARMT_Symbol.points_set		= {"stroke_symbols_MFDG", "PACS_Mode_Box"}
		ARMT_Symbol.scale			= MFDG_STRK_SCALE
AddMFDGStrokeSymbol(ARMT_Symbol)

local	ARMT_Symbol					= CreateElement "ceSMultiLine"
		ARMT_Symbol.name			= "AG_OPTIONS_LINES"
		ARMT_Symbol.material		= stroke_material
		ARMT_Symbol.init_pos		= {0, PosY(-0.20), 0}
		ARMT_Symbol.parent_element	= "Multiple_Release_Options"
		ARMT_Symbol.points_set		= {"stroke_symbols_MFDG", "AG_Lines"}
		ARMT_Symbol.scale			= MFDG_STRK_SCALE
AddMFDGStrokeSymbol(ARMT_Symbol)

local	ARMT_Symbol					= CreateElement "ceSMultiLine"
		ARMT_Symbol.name			= "AC_REL_MODE"
		ARMT_Symbol.material		= stroke_material
		ARMT_Symbol.init_pos		= {PosX(0.68), PosY( 0.555), 0}
		ARMT_Symbol.parent_element	= "Multiple_Release_Options"
		ARMT_Symbol.controllers		= {{"armt_Current_Mode"}}
		ARMT_Symbol.points_set		= {"stroke_symbols_MFDG", "PACS_Mode_Box"}
		ARMT_Symbol.scale			= MFDG_STRK_SCALE
AddMFDGStrokeSymbol(ARMT_Symbol)
